(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     18619,        567]
NotebookOptionsPosition[     17588,        527]
NotebookOutlinePosition[     17925,        542]
CellTagsIndexPosition[     17882,        539]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Author", ":", " ", 
     RowBox[{"Alen", " ", "Lancic"}]}], ",", " ", 
    RowBox[{
     RowBox[{"alen", ".", 
      RowBox[{"lancic", "@", "gmail"}], ".", "com"}], "\[IndentingNewLine]", 
     "G", " ", "is", " ", "function", " ", "which", " ", "calculates", " ", 
     "coefficients", " ", "n", " ", "is", " ", "a", " ", "number", " ", "of", 
     " ", "neighbours"}], ",", 
    RowBox[{
    "L2", " ", "is", " ", "a", " ", "list", " ", "of", " ", "coefficients", 
     " ", "for", " ", "variables", " ", 
     RowBox[{"Subscript", "[", 
      RowBox[{"x", ",", "1"}], "]"}]}], ",", "...", ",", 
    RowBox[{
     RowBox[{"Subscript", "[", 
      RowBox[{"x", ",", "k"}], "]"}], " ", "and", " ", "eL", " ", "is", " ", 
     "the", " ", "time", " ", "remaining", " ", "time", " ", "until", " ", 
     "the", " ", "end", " ", "of", " ", "the", " ", "simulation"}]}], "*)"}], 
  
  RowBox[{
   RowBox[{
    RowBox[{"G", "[", 
     RowBox[{"n_", ",", "L2_", ",", "el_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"k", "=", 
         RowBox[{"Length", "[", "L2", "]"}]}], ",", 
        RowBox[{"M", "=", 
         RowBox[{"Max", "[", "L2", "]"}]}], ",", 
        RowBox[{"z", "=", 
         RowBox[{"Total", "[", "L2", "]"}]}]}], "}"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"el", "\[Equal]", "0"}], ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"k", "\[Equal]", "0"}], ",", "1", ",", "0"}], "]"}], ",", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"k", "\[Equal]", "0"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "q"}], ")"}], "^", "el"}], " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "p"}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{"el", " ", "n"}], ")"}]}]}], "+", 
           RowBox[{"q", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "p"}], ")"}], "^", "n"}], "-", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "p"}], ")"}], "^", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", "el"}], ")"}], " ", "n"}], ")"}]}], " ", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "q"}], ")"}], "^", "el"}]}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "-", "p"}], ")"}], "^", "n"}], "+", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", "p"}], ")"}], "^", "n"}], " ", "q"}]}], 
              ")"}]}]}]}], ",", 
          RowBox[{
           RowBox[{"p", "^", "k"}], " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "p"}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"z", "-", "k"}], ")"}]}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "q"}], ")"}], "^", "el"}], " ", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "p"}], ")"}], "^", 
               RowBox[{"(", 
                RowBox[{"el", " ", 
                 RowBox[{"(", 
                  RowBox[{"n", "-", "k"}], ")"}]}], ")"}]}]}], "+", 
             RowBox[{"q", " ", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "q"}], ")"}], "^", 
                   RowBox[{"(", 
                    RowBox[{"M", "-", "1"}], ")"}]}], " ", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "p"}], ")"}], "^", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"n", "-", "k"}], ")"}], " ", "M"}], ")"}]}]}], 
                 "-", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "q"}], ")"}], "^", "el"}], " ", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "p"}], ")"}], "^", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"el", "+", "1"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{"n", "-", "k"}], ")"}]}], ")"}]}]}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "-", "q"}], ")"}], " ", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "-", "p"}], ")"}], "^", 
                   RowBox[{"(", 
                    RowBox[{"n", "-", "k"}], ")"}]}]}]}], ")"}]}]}]}], 
            ")"}]}]}], "]"}]}], "]"}]}], "]"}]}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.604223356205557*^9, 3.6042233577759113`*^9}, {
  3.609070346637236*^9, 3.609070361675974*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "=", "5"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"p", "=", "0.2"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"q", "=", "0.3"}], ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.604223367161539*^9, 3.604223368927725*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"node", " ", "11"}], "*)"}], "\n", 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"n1", "=", "1"}], "t"], 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"n2", "=", "1"}], "t"], 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"n3", "=", "1"}], "t"], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"n4", "=", "1"}], "t"], 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"n5", "=", "1"}], 
        RowBox[{"t", "-", "n4"}]], 
       RowBox[{
        RowBox[{"G", "[", 
         RowBox[{"4", ",", 
          RowBox[{"{", 
           RowBox[{"n1", ",", "n2", ",", "n3", ",", "n4"}], "}"}], ",", "t"}],
          "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"3", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"t", "-", "n1"}]}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"2", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"t", "-", "n3"}]}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"3", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"t", "-", "n2"}]}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"3", ",", 
          RowBox[{"{", "n5", "}"}], ",", 
          RowBox[{"t", "-", "n4"}]}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"2", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"t", "-", "n4", "-", "n5"}]}], "]"}]}]}]}]}]}]}]}]], "Input",\

 CellChangeTimes->{{3.6042233764444103`*^9, 3.604223376445587*^9}}],

Cell[BoxData["0.0003924644900609609`"], "Output",
 CellChangeTimes->{3.6042233781838617`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"node", " ", "10"}], "*)"}], "\n", 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"n2", "=", "1"}], "t"], 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"n1", "=", "1"}], 
     RowBox[{"t", "-", "n2"}]], 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"n3", "=", "1"}], 
      RowBox[{"t", "-", "n2"}]], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"n4", "=", "1"}], 
       RowBox[{"t", "-", "n2"}]], 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"n5", "=", "1"}], 
        RowBox[{"t", "-", "n2", "-", "n4"}]], 
       RowBox[{
        RowBox[{"G", "[", 
         RowBox[{"4", ",", 
          RowBox[{"{", "n2", "}"}], ",", "t"}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"3", ",", 
          RowBox[{"{", 
           RowBox[{"n1", ",", "n3", ",", "n4"}], "}"}], ",", 
          RowBox[{"t", "-", "n2"}]}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"3", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"t", "-", "n2", "-", "n1"}]}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"2", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"t", "-", "n2", "-", "n3"}]}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"3", ",", 
          RowBox[{"{", "n5", "}"}], ",", 
          RowBox[{"t", "-", "n2", "-", "n4"}]}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"2", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"t", "-", "n2", "-", "n4", "-", "n5"}]}], 
         "]"}]}]}]}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.60422338371931*^9, 3.604223384388156*^9}}],

Cell[CellGroupData[{

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.604223391430819*^9, 3.604223392304435*^9}}],

Cell[BoxData["0.0001368350445150416`"], "Output",
 CellChangeTimes->{3.6042233850486193`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"node", " ", "12"}], "*)"}], "\n", 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"n3", "=", "1"}], "t"], 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"n1", "=", "1"}], 
     RowBox[{"t", "-", "n3"}]], 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"n2", "=", "1"}], 
      RowBox[{"t", "-", "n3"}]], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"n4", "=", "1"}], 
       RowBox[{"t", "-", "n3"}]], 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"n5", "=", "1"}], 
        RowBox[{"t", "-", "n3", "-", "n4"}]], 
       RowBox[{
        RowBox[{"G", "[", 
         RowBox[{"3", ",", 
          RowBox[{"{", "n3", "}"}], ",", "t"}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"3", ",", 
          RowBox[{"{", 
           RowBox[{"n1", ",", "n2", ",", "n4"}], "}"}], ",", 
          RowBox[{"t", "-", "n3"}]}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"3", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"t", "-", "n3", "-", "n1"}]}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"3", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"t", "-", "n3", "-", "n2"}]}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"3", ",", 
          RowBox[{"{", "n5", "}"}], ",", 
          RowBox[{"t", "-", "n3", "-", "n4"}]}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"2", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"t", "-", "n3", "-", "n4", "-", "n5"}]}], 
         "]"}]}]}]}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.604223394956154*^9, 3.604223395520906*^9}}],

Cell[BoxData["0.00017727886897449832`"], "Output",
 CellChangeTimes->{3.604223396380877*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"node", " ", "7"}], "*)"}], "\n", 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"n1", "=", "1"}], "t"], 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"n2", "=", "1"}], 
     RowBox[{"t", "-", "n1"}]], 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"n3", "=", "1"}], 
      RowBox[{"t", "-", "n1"}]], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"n4", "=", "1"}], 
       RowBox[{"t", "-", "n1"}]], 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"n5", "=", "1"}], 
        RowBox[{"t", "-", "n1", "-", "n4"}]], 
       RowBox[{
        RowBox[{"G", "[", 
         RowBox[{"4", ",", 
          RowBox[{"{", "n1", "}"}], ",", "t"}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"3", ",", 
          RowBox[{"{", 
           RowBox[{"n2", ",", "n3", ",", "n4"}], "}"}], ",", 
          RowBox[{"t", "-", "n1"}]}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"3", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"t", "-", "n1", "-", "n2"}]}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"2", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"t", "-", "n1", "-", "n3"}]}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"3", ",", 
          RowBox[{"{", "n5", "}"}], ",", 
          RowBox[{"t", "-", "n1", "-", "n4"}]}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"2", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"t", "-", "n1", "-", "n4", "-", "n5"}]}], 
         "]"}]}]}]}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.6042233970790854`*^9, 3.604223403094329*^9}}],

Cell[BoxData["0.0001368350445150416`"], "Output",
 CellChangeTimes->{3.6042234040623627`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"node", " ", "15"}], "*)"}], "\n", 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"n5", "=", "1"}], "t"], 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"n4", "=", "1"}], "t"], 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"n1", "=", "1"}], 
      RowBox[{"t", "-", "n4"}]], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"n2", "=", "1"}], 
       RowBox[{"t", "-", "n4"}]], 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"n3", "=", "1"}], 
        RowBox[{"t", "-", "n4"}]], 
       RowBox[{
        RowBox[{"G", "[", 
         RowBox[{"4", ",", 
          RowBox[{"{", 
           RowBox[{"n4", ",", "n5"}], "}"}], ",", "t"}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"2", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"t", "-", "n5"}]}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"3", ",", 
          RowBox[{"{", 
           RowBox[{"n1", ",", "n2", ",", "n3"}], "}"}], ",", 
          RowBox[{"t", "-", "n4"}]}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"3", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"t", "-", "n4", "-", "n1"}]}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"3", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"t", "-", "n4", "-", "n2"}]}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"2", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"t", "-", "n4", "-", "n3"}]}], "]"}]}]}]}]}]}]}]}]], "Input",\

 CellChangeTimes->{{3.6042234049155416`*^9, 3.6042234107913647`*^9}}],

Cell[BoxData["0.00022194899106790886`"], "Output",
 CellChangeTimes->{3.60422341153302*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"node", " ", "19"}], "*)"}], "\n", 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"n5", "=", "1"}], "t"], 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"n4", "=", "1"}], 
     RowBox[{"t", "-", "n5"}]], 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"n1", "=", "1"}], 
      RowBox[{"t", "-", "n4", "-", "n5"}]], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"n2", "=", "1"}], 
       RowBox[{"t", "-", "n4", "-", "n5"}]], 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"n3", "=", "1"}], 
        RowBox[{"t", "-", "n4", "-", "n5"}]], 
       RowBox[{
        RowBox[{"G", "[", 
         RowBox[{"3", ",", 
          RowBox[{"{", "n5", "}"}], ",", "t"}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"3", ",", 
          RowBox[{"{", "n4", "}"}], ",", 
          RowBox[{"t", "-", "n5"}]}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"3", ",", 
          RowBox[{"{", 
           RowBox[{"n1", ",", "n2", ",", "n3"}], "}"}], ",", 
          RowBox[{"t", "-", "n5", "-", "n4"}]}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"3", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"t", "-", "n5", "-", "n4", "-", "n2"}]}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"3", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"t", "-", "n5", "-", "n4", "-", "n1"}]}], "]"}], "*", 
        RowBox[{"G", "[", 
         RowBox[{"2", ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"t", "-", "n5", "-", "n4", "-", "n3"}]}], 
         "]"}]}]}]}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.604223411862835*^9, 3.6042234181421747`*^9}}],

Cell[BoxData["0.00015534191360930342`"], "Output",
 CellChangeTimes->{3.604223420357456*^9}]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.6042234209712133`*^9}]
},
WindowSize->{740, 867},
WindowMargins->{{-64, Automatic}, {Automatic, 4}},
FrontEndVersion->"8.0 for Linux x86 (64-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 5563, 148, 297, "Input"],
Cell[6123, 170, 322, 9, 107, "Input"],
Cell[CellGroupData[{
Cell[6470, 183, 1564, 47, 105, "Input"],
Cell[8037, 232, 93, 1, 30, "Output"]
}, Open  ]],
Cell[8145, 236, 1716, 49, 143, "Input"],
Cell[CellGroupData[{
Cell[9886, 289, 92, 1, 30, "Input"],
Cell[9981, 292, 93, 1, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10111, 298, 1717, 49, 143, "Input"],
Cell[11831, 349, 92, 1, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11960, 355, 1718, 49, 143, "Input"],
Cell[13681, 406, 93, 1, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13811, 412, 1680, 49, 143, "Input"],
Cell[15494, 463, 91, 1, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15622, 469, 1763, 49, 143, "Input"],
Cell[17388, 520, 92, 1, 30, "Output"]
}, Open  ]],
Cell[17495, 524, 89, 1, 50, "Input"]
}
]
*)

(* End of internal cache information *)
